﻿if (window.widget)
{
    widget.onshow = onshow;
    widget.onhide = onhide;
}

var connectedToPower = false;
var charging = false;
var batteryPromilage = 0;
var msToCapacity = 0;
var msToZero = 0;
var timer = null;
var hasMs = false;
var hasBattery = false;
var hasCheckedOnce = false;
var shown = false;


function onshow(){
	shown=true;
	if (timer==null)
	{
		timer = setInterval ("readOutBattery();", 15000);
	}else{
		clearInterval(timer);
		timer = setInterval ("readOutBattery();", 15000);
	}
	updateInterface();
	readOutBattery();
}


function onhide(){
	shown=false;
	if (timer==null)
	{
		timer = setInterval ("readOutBattery();", 30000);
	}else{
		clearInterval(timer);
		timer = setInterval ("readOutBattery();", 30000);
	}
}


function updateInterface(){
	if (shown && hasCheckedOnce){
		var percentage = document.getElementById("percentage");
		var batterystatus = document.getElementById("batterystatus");
		var calculation = document.getElementById("calculation");
		var meter = document.getElementById("meter");
		if (!hasBattery){
			batterystatus.innerText = 'No Battery...';
			percentage.innerText = '- %';
			calculation.innerText = 'No Battery Found';
			return;
		}
		if (batteryPromilage==0) percentage.innerText='0%';
		else if (batteryPromilage==1000) percentage.innerText='100%';
		else percentage.innerText=Math.floor(batteryPromilage/10)+"."+(batteryPromilage%10)+"%";
		
		if (batteryPromilage>900){
			meter.src='100.png';
		}else if (batteryPromilage>800){
			meter.src='90.png';
		}else if (batteryPromilage>700){
			meter.src='80.png';
		}else if (batteryPromilage>600){
			meter.src='70.png';
		}else if (batteryPromilage>500){
			meter.src='60.png';
		}else if (batteryPromilage>400){
			meter.src='50.png';
		}else if (batteryPromilage>300){
			meter.src='40.png';
		}else if (batteryPromilage>200){
			meter.src='30.png';
		}else if (batteryPromilage>100){
			meter.src='20.png';
		}else if (batteryPromilage>50){
			meter.src='10.png';
		}else{
			meter.src='5.png';
		}
		if (connectedToPower){
			if (charging){
				batterystatus.innerText='Charging...';
				if (hasMs){
					calculation.innerText= getTime(msToCapacity)+ ' until Full';
				}else{
					calculation.innerText='Calculating...';
				}
			}
			else{
				if (batteryPromilage>900){
					batterystatus.innerText='Charged...';
					calculation.innerText='Battery is Full';
				}else if (batteryPromilage<100){
					batterystatus.innerText='Waiting...';
					calculation.innerText='Battery is Empty';
				}else{
					batterystatus.innerText='Waiting...';
					calculation.innerText='Waiting';
				}
			}
		}else{
			batterystatus.innerText='On Battery...';
			if (hasMs){
				calculation.innerText= getTime(msToZero)+ ' Remaining';
			}else{
				calculation.innerText='Calculating...';
			}
		}
	}
}

function getTime(input){
	var hours = Math.floor((input/1000)/3600);
	var minutes = Math.floor((input/1000)/60) % 60;
	var output = ''+hours+':'+(minutes>9?''+minutes:'0'+minutes);
	return output;
}


var current_7 = 0;
var current_6 = 0;
var current_5 = 0;
var current_4 = 0;
var current_3 = 0;
var current_2 = 0;
var current_1 = 0;
var timer_7 = null;
var timer_6 = null;
var timer_5 = null;
var timer_4 = null;
var timer_3 = null;
var timer_2 = null;
var timer_1 = null;
var flipHistory = false;
var connectedToPower_1 = false;

var command = null;

function readOutBattery(){
	//command = widget.system("/usr/sbin/ioreg -p IODeviceTree -n \"battery\" -w 0| grep IOBatteryInfo", handleBatteryResponse);
	command = widget.system("/usr/sbin/ioreg -p IOPower -n IOPMrootDomain -w 0 | grep IOBatteryInfo", handleBatteryResponse);
}

function handleBatteryResponse(cmd){
	var bb = document.getElementById("bb");
	
	var output = cmd.outputString;
	
	hasCheckedOnce=true;

	if (output && output.length>10){
		hasBattery = true;
		//Grab the properties substring
		output = output.substring(output.indexOf("{")+1, output.indexOf("}"));

		//Grab properties
				
		var capacity = 0;
		var current = 0;
		var amperage = 0;
		var voltage = 0;
		var flags = 0;
		var timer = new Date();
		
		while (output.length>1){
			var c = output.indexOf(",");
			var pc = '';
			if (c>-1){
				pc = output.substring(0, output.indexOf(","));
				output = output.substring(output.indexOf(",")+1);
			}else{
				pc = output;
				output = '';
			}
			var name = pc.substring(1, pc.indexOf("=")-1);
			var value = pc.substring(pc.indexOf("=")+1);
			if (name == 'Capacity') capacity = value;
			if (name == 'Current') current = value;
			if (name == 'Amperage') amperage = value;
			if (name == 'Voltage') voltage = value;
			if (name == 'Flags') flags = value;
		}
		connectedToPower = flags!=4 && flags!=20 && flags!=148;
		if (connectedToPower_1!=connectedToPower){	//Clear on ac change
			timer_1=null; timer_2=null; timer_3=null; timer_4=null; timer_5=null; timer_6=null; timer_7=null;
		}
		if (timer_1!=null && timer.getTime()-timer_1.getTime()>70000){	//Clear on back from sleep
			timer_1=null; timer_2=null; timer_3=null; timer_4=null; timer_5=null; timer_6=null; timer_7=null;
		}
		
		connectedToPower_1=connectedToPower;

		if (timer_7!=null){
			msToCapacity = (timer.getTime()-timer_7.getTime()) / (current-current_7) * (capacity-current);
			msToZero = (timer.getTime()-timer_7.getTime()) / (current_7-current) * (current);
			msToCapacity = Math.floor(msToCapacity);
			msToZero = Math.floor(msToZero);
			hasMs=true;
		}else if (timer_6!=null){
			msToCapacity = (timer.getTime()-timer_6.getTime()) / (current-current_6) * (capacity-current);
			msToZero = (timer.getTime()-timer_6.getTime()) / (current_6-current) * (current);
			msToCapacity = Math.floor(msToCapacity);
			msToZero = Math.floor(msToZero);
			hasMs=true;
		}else if (timer_5!=null){
			msToCapacity = (timer.getTime()-timer_5.getTime()) / (current-current_5) * (capacity-current);
			msToZero = (timer.getTime()-timer_5.getTime()) / (current_5-current) * (current);
			msToCapacity = Math.floor(msToCapacity);
			msToZero = Math.floor(msToZero);
			hasMs=true;
		}else if (timer_4!=null){
			msToCapacity = (timer.getTime()-timer_4.getTime()) / (current-current_4) * (capacity-current);
			msToZero = (timer.getTime()-timer_4.getTime()) / (current_4-current) * (current);
			msToCapacity = Math.floor(msToCapacity);
			msToZero = Math.floor(msToZero);
			hasMs=true;
		}else if (timer_3!=null){
			msToCapacity = (timer.getTime()-timer_3.getTime()) / (current-current_3) * (capacity-current);
			msToZero = (timer.getTime()-timer_3.getTime()) / (current_3-current) * (current);
			msToCapacity = Math.floor(msToCapacity);
			msToZero = Math.floor(msToZero);
			hasMs=true;
		}else if (timer_2!=null){
			msToCapacity = (timer.getTime()-timer_2.getTime()) / (current-current_2) * (capacity-current);
			msToZero = (timer.getTime()-timer_2.getTime()) / (current_2-current) * (current);
			msToCapacity = Math.floor(msToCapacity);
			msToZero = Math.floor(msToZero);
			//hasMs=true;
		}else{hasMs = false; }
		charging=amperage>0 && connectedToPower;
		batteryPromilage=Math.floor((current*1000+0.5)/capacity);
		
		flipHistory = !flipHistory;
		if (flipHistory){
			timer_7=timer_6;timer_6=timer_5;timer_5=timer_4; timer_4=timer_3; timer_3=timer_2;timer_2=timer_1;timer_1=timer;
			current_7=current_6;current_6=current_5;current_5=current_4; current_4=current_3; current_3=current_2;current_2=current_1;current_1=current;
		}
		
/*		bb.innerHTML=	'promilage: '+batteryPromilage+
						'<BR>ms -> full: '+msToCapacity+
						'<BR>ms -> empty: '+msToZero+
						'<BR>has ms: '+hasMs+
						'<BR>connected : ' +connectedToPower+
						'<BR>charging: '+charging;*/
						
	}
	updateInterface();
}
